<?php
$servername = "localhost";
$database = "bancoguijao";
$username = "root";
$password = "";
$dsn = "mysql:host=$servername;dbname=$database;charset=utf8mb4";
$dsn_Options = [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION];

try {
    $pdo = new PDO($dsn, $username, $password, $dsn_Options);
} catch (PDOException $error) {
    die('Erro na conexão: ' . $error->getMessage());
}
?>
<html>
<head>
    <meta charset="UTF-8">
    <title>Consultas - Banco Guijao</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<h2>Consultas do Banco Guijao</h2>
<div class="container">
<?php
$sql1 = "SELECT 
            MAX(luminosidade) AS max_luminosidade,
            COUNT(velocidade) AS qtd_velocidade,
            MIN(luminosidade) AS min_luminosidade,
            SUM(velocidade) AS soma_velocidade,
            COUNT(capacidade) AS qtd_capacidade,
            MAX(umidade) AS max_umidade
         FROM leituraguijao";
$res1 = $pdo->query($sql1)->fetch(PDO::FETCH_ASSOC);

echo "<h3>1º Container</h3>";
echo "<table><tr>
        <th>Max Luminosidade</th><th>Qtd Velocidade</th>
        <th>Min Luminosidade</th><th>Soma Velocidade</th>
        <th>Qtd Capacidade</th><th>Max Umidade</th>
      </tr>";
echo "<tr>
        <td>{$res1['max_luminosidade']}</td>
        <td>{$res1['qtd_velocidade']}</td>
        <td>{$res1['min_luminosidade']}</td>
        <td>{$res1['soma_velocidade']}</td>
        <td>{$res1['qtd_capacidade']}</td>
        <td>{$res1['max_umidade']}</td>
      </tr></table>";

$sql2 = "SELECT 
            MIN(luminosidade) AS min_luminosidade,
            SUM(velocidade) AS soma_velocidade
         FROM leituraguijao
         WHERE MONTH(dataleitura) = 9";
$res2 = $pdo->query($sql2)->fetch(PDO::FETCH_ASSOC);

echo "<h3>2º Container</h3>";
echo "<table><tr>
        <th>Min Luminosidade (Set)</th><th>Soma Velocidade (Set)</th>
      </tr>";
echo "<tr>
        <td>{$res2['min_luminosidade']}</td>
        <td>{$res2['soma_velocidade']}</td>
      </tr></table>";

$sql3 = "SELECT 
            SUM(temperatura) AS soma_temperatura,
            MIN(capacidade) AS min_capacidade
         FROM leituraguijao
         WHERE MONTH(dataleitura) BETWEEN 8 AND 9";
$res3 = $pdo->query($sql3)->fetch(PDO::FETCH_ASSOC);

echo "<h3>3º Container</h3>";
echo "<table><tr>
        <th>Soma Temperatura (Ago-Set)</th><th>Min Capacidade (Ago-Set)</th>
      </tr>";
echo "<tr>
        <td>{$res3['soma_temperatura']}</td>
        <td>{$res3['min_capacidade']}</td>
      </tr></table>";

$sql4 = "SELECT dataleitura, horaleitura, velocidade, capacidade, temperatura, umidade, luminosidade
         FROM leituraguijao";
$res4 = $pdo->query($sql4);

echo "<h3>4º Container</h3>";
echo "<table><tr>
        <th>Data</th><th>Hora</th><th>Velocidade</th>
        <th>Capacidade</th><th>Temperatura</th>
        <th>Umidade</th><th>Luminosidade</th>
      </tr>";
foreach ($res4 as $row) {
    echo "<tr>
            <td>{$row['dataleitura']}</td>
            <td>{$row['horaleitura']}</td>
            <td>{$row['velocidade']}</td>
            <td>{$row['capacidade']}</td>
            <td>{$row['temperatura']}</td>
            <td>{$row['umidade']}</td>
            <td>{$row['luminosidade']}</td>
          </tr>";
}
echo "</table>";
?>
</div>
</body>
</html>
