<?php

require_once './conectaBanco.php';

$pdo = conectaBanco();

$sql = "
    SELECT 
        AVG(luminosidade) AS soma1,
        AVG(comprimento) AS soma2,
        MIN(velocidade) AS soma3,
        SUM(luminosidade) AS soma4,
        COUNT(umidade) AS soma5,
        MAX(comprimento) AS soma6
    FROM leiturakafe;
";

$dados = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

$sql = "SELECT 
MIN(velocidade) AS velo,
SUM(luminosidade) AS lumi
FROM leiturakafe
WHERE dataleitura BETWEEN '2025-09-01' AND '2025-09-30';";

$dados2 = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

$sql = "SELECT COUNT(velocidade) AS velo2,
            MAX(umidade) AS umi2
            FROM leiturakafe
        WHERE horaleitura BETWEEN '00:00:00' AND '12:00:00';";

$dados3 = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

$sql = "SELECT dataleitura,
            horaleitura,
            umidade,
            velocidade,
            longitude,
            luminosidade
        FROM leiturakafe";

$dados4 = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

// Extra 1 = comprimento
// Extra 2 = velocidade
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Leituras Registradas</title>
    <link rel="icon" href="./assets/tableAvatar.png">

    <link rel="stylesheet" href="./assets/Estilos/style.css" type="text/css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/css/bootstrap.min.css" rel="stylesheet">

</head>
<body>
    <div class="container">

    <div class="mt-3 ml-3">
        <h2 class="b-m4">Questão 1</h2> <br> <a type="submit" href="./export.php" class="btn btn-secondary flex-fill text-center mb-3">
                                                                <i class="fa-solid fa-file-excel"></i></a>
        <br>
        <table class="table table-bordered table-hover table-stripped table-light">
            <thead class="table-dark">
                <tr>
                    <th>AVG Luminosidade</th>
                    <th>AVG Comprimento</th>
                    <th>MIN velocidade</th>
                    <th>SUM luminosidade</th>
                    <th>COUNT Umidade</th>
                    <th>MAX Comprimento</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($dados as $linha): ?>
                    <tr>
                        <td><?= $linha['soma1'] ?></td>
                        <td><?= $linha['soma2'] ?></td>
                        <td><?= $linha['soma3'] ?></td>
                        <td><?= $linha['soma4'] ?></td>
                        <td><?= $linha['soma5'] ?></td>
                        <td><?= $linha['soma6'] ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        </div>
    </div>
    
    </div>

    <div class="container">

    <div class="mt-3 ml-3">
        <h2 class="b-m4">Questão 2</h2> <br>
        <br>
        <table class="table table-bordered table-hover table-stripped table-light">
            <thead class="table-dark">
                <tr>
                    <th>MIN Velocidade</th>
                    <th>SUM Luminosidade</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($dados2 as $linha): ?>
                    <tr>
                        <td><?= $linha['velo'] ?></td>
                        <td><?= $linha['lumi'] ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        </div>

    </div>

    </div>

    <div class="container">

    <div class="mt-3 ml-3">
        <h2 class="b-m4">Questão 3</h2> <br>
        <br>
        <table class="table table-bordered table-hover table-stripped table-light">
            <thead class="table-dark">
                <tr>
                    <th>COUNT Velocidade</th>
                    <th>MAX Umidade</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($dados3 as $linha): ?>
                    <tr>
                        <td><?= $linha['velo2'] ?></td>
                        <td><?= $linha['umi2'] ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        </div>

    </div>

    </div>

    <div class="container">

    <div class="mt-3 ml-3">
        <h2 class="b-m4">Questão 4</h2> <br> <a type="submit" href="./export.php" class="btn btn-secondary flex-fill text-center mb-3">
                                                                <i class="fa-solid fa-file-excel"></i></a>
        <br>
        <table class="table table-bordered table-hover table-stripped table-light">
            <thead class="table-dark">
                <tr>
                    <th>Data Leitura</th>
                    <th>Hora Leitura</th>
                    <th>Umidade</th>
                    <th>Velocidade</th>
                    <th>Longitude</th>
                    <th>Luminosidade</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($dados4 as $linha): ?>
                    <tr>
                        <td><?= $linha['dataleitura'] ?></td>
                        <td><?= $linha['horaleitura'] ?></td>
                        <td><?= $linha['umidade'] ?></td>
                        <td><?= $linha['velocidade'] ?></td>
                        <td><?= $linha['longitude'] ?></td>
                        <td><?= $linha['luminosidade'] ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        </div>
    </div>
</body>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/js/bootstrap.min.js" integrity="sha384-G/EV+4j2dNv+tEPo3++6LCgdCROaejBqfUeNjuKAiuXbjrxilcCdDz6ZAVfHWe1Y" crossorigin="anonymous"></script>

</html>